unit Unit1;
(*
program: UplIniBuilder
author: Robert M. Czerwinski
copyright: The Delphi Super Page
release: 1.0.0.0
date: 12/12/1998

This program creates uplbuild.dat file, which is in fact a simple
ini file ( I am not going to reinvent a wheel ). uplbuild.dat file
is used as a data source ( groups, compilers, categories etc ) by
UPLBuilder when run in non-database mode ( compiled without DSP
database support or run without appropriate alias: DelphiSuperPage
defined in the system ).

As you can see it is nothing special. I just included this little app
in this UPLBuilder release to show you where uplbuild.dat file comes
from. In my UPLReader I do not use this file - I use DSP database
instead.

*)
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Db, DBTables;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses IniFiles,
     Upl_util,
     Upl_cons,
     Unit2;

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var
  TIni: TIniFile;
  GroupID,
  i, k: integer;
  GroupName,
  CompilerID,
  CompilerName: String;
begin

  TIni:= TIniFile.Create(GetDirectory + cUPL_UplBuilderDataFile);
  try

    Color:= clRed;
    Application.ProcessMessages;

    //
    // write DSP main groups: component/code, resource, docs ...
    //
    DM.TblFileGroup.First;
    TIni.WriteString(cUPL_DSPGroups, cUPL_Count, IntToStr(DM.TblFileGroup.RecordCount));
    i:= 0;
    while not DM.TblFileGroup.EOF do Begin
      Inc(i);
      TIni.WriteString(cUPL_DSPGroups,
                       IntToStr(i),
                       DM.TblFileGroup.FieldByName('FileGrpName').AsString);
      DM.TblFileGroup.Next;
    End;

    // write compilers in predefined order, and all sections available for each
    // compiler. To control compilers order I have to add this index. This grant
    // me that compilers will be printed in the following order:
    // delphi 1.0 -> delphi 4.0 -> C++Builder 1.0 -> C++Builder 3.0 -> JBuilder 1.0
    // this is important because compilers ORDER is used to deduce
    // upload target dir, ie if file is marked as d20, d30 & c30 compatible
    // it will be stored in d20xxxx directory ie the lowest compiler from
    // the compiler list ( see TDSPCompilerList class in ..\common\uplclass.pas file )

    DM.TblCompilers.IndexName:= 'ByOrder';
    DM.TblCompilers.First;
    TIni.WriteString(cUPL_ComponentCode,
                     cUPL_Count,
                     IntToStr(DM.TblCompilers.RecordCount));
    i:= 0;
    while not DM.TblCompilers.EOF do Begin
      Inc(i);
      TIni.WriteString(cUPL_ComponentCode,
                       IntToStr(i),
                       DM.TblCompilers.FieldByName('CompilerID').AsString + ',' +
                       DM.TblCompilers.FieldByName('CompilerName').AsString);
      //
      // available sections for each compilers will be stored in
      // TblCompilers.FieldByName('CompilerName').AsString section
      //
      CompilerID:= DM.TblCompilers.FieldByName('CompilerID').AsString;
      CompilerName:= DM.TblCompilers.FieldByName('CompilerName').AsString;
      DM.TblFileCategory.First;
      k:= 0;
      while not DM.TblFileCategory.EOF do Begin
        if DM.TblFileCategory.FieldByName('FileGrpID').AsInteger = 1 then
         if DM.TblFileCategory.FieldByName(CompilerID).AsBoolean then
        Begin
           Inc(k);
           TIni.WriteString(CompilerName,   //section
                           IntToStr(k),     //key
                           DM.TblFileCategory.FieldByName('FileCatName').AsString );
        End;
        DM.TblFileCategory.Next;
      end;
      TIni.WriteString(CompilerName, cUPL_Count, IntToStr(k));
      DM.TblCompilers.Next;
    End;

    //
    // write available sections for each group
    // ignore Component/Code ( group = 1 )
    //
    DM.TblFileGroup.First;
    while not DM.TblFileGroup.EOF do Begin
      if DM.TblFileGroup.FieldByName('FileGrpID').AsInteger <> 1 then
      Begin
        GroupName:= DM.TblFileGroup.FieldByName('FileGrpName').AsString;
        GroupID:= DM.TblFileGroup.FieldByName('FileGrpID').AsInteger;
        // write Count line for each section
        DM.TblFileCategory.First;
        i:= 0;
        while not DM.TblFileCategory.EOF do Begin
          if DM.TblFileCategory.FieldByName('FileGrpID').AsInteger = GroupID then
          Begin
            Inc(i);
            TIni.WriteString(GroupName,
                             IntToStr(i),
                             DM.TblFileCategory.FieldByName('FileCatName').AsString );
          End;
          DM.TblFileCategory.Next;
        end;
        TIni.WriteString(GroupName, cUPL_DSPDir, DM.TblFileGroup.FieldByName('DSPDir').AsString);
        TIni.WriteString(GroupName, cUPL_Count, IntToStr(i));
      End;
      DM.TblFileGroup.Next;
    End;

    //
    // write DSP site(author) categories
    //
    DM.TblSiteCategory.First;
    TIni.WriteString(cUPL_AuthorGroup,
                     cUPL_Count,
                     IntToStr(DM.TblSiteCategory.RecordCount));
    i:= 0;
    while not DM.TblSiteCategory.EOF do Begin
      Inc(i);
      TIni.WriteString(cUPL_AuthorGroup,
                       IntToStr(i),
                       DM.TblSiteCategory.FieldByName('Description').AsString);
      DM.TblSiteCategory.Next;
    End;

    //
    // write DSP file platforms ( apply only to tools )
    //
    DM.TblFilePlatform.First;
    TIni.WriteString(cUPL_FilePlatform,
                     cUPL_Count,
                     IntToStr(DM.TblFilePlatform.RecordCount));
    i:= 0;
    while not DM.TblFilePlatform.EOF do Begin
      Inc(i);
      TIni.WriteString(cUPL_FilePlatform,
                       IntToStr(i),
                       DM.TblFilePlatform.FieldByName('PlatformName').AsString);
      DM.TblFilePlatform.Next;
    End;
  finally
    Color:= clBtnFace;
    TIni.Destroy;
    Button1.Caption:= 'Done!';
    Button1.Enabled:= false;
  End;
end;

end.
